/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsbc;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.networking.simple.SimpleNetworkManager;
import dev.ftb.ftbsbc.FTBStoneBlockCommands;
import dev.ftb.ftbsbc.config.FTBSBConfig;
import dev.ftb.ftbsbc.dimensions.DimensionsClient;
import dev.ftb.ftbsbc.dimensions.DimensionsMain;
import dev.ftb.ftbsbc.dimensions.DimensionsRegistry;
import dev.ftb.ftbsbc.dimensions.net.CreateDimensionForTeam;
import dev.ftb.ftbsbc.dimensions.net.ShowSelectionGui;
import dev.ftb.ftbsbc.dimensions.net.SyncArchivedDimensions;
import dev.ftb.ftbsbc.dimensions.net.UpdateDimensionsList;
import dev.ftb.ftbsbc.portal.PortalClient;
import dev.ftb.ftbsbc.portal.PortalRegistry;
import dev.ftb.ftbsbc.tools.ToolsClient;
import dev.ftb.ftbsbc.tools.ToolsMain;
import dev.ftb.ftbsbc.tools.ToolsRegistry;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ftbsbc")
public class FTBStoneBlock {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "ftbsbc";
    public static final SimpleNetworkManager NET = SimpleNetworkManager.create((String)"ftbsbc");
    public static final MessageType UPDATE_DIMENSION_LIST = NET.registerS2C("update_dimensions_list", UpdateDimensionsList::new);
    public static final MessageType CREATE_DIMENSION_FOR_TEAM = NET.registerC2S("create_dimension_for_team", CreateDimensionForTeam::new);
    public static final MessageType SHOW_SELECTION_GUI = NET.registerS2C("show_start_selection", ShowSelectionGui::new);
    public static final MessageType SYNC_ARCHIVED_DIMENSIONS = NET.registerS2C("sync_archived_dimensions", SyncArchivedDimensions::new);

    public FTBStoneBlock() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)FTBSBConfig.COMMON_CONFIG);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        Stream.of(ToolsRegistry.REGISTERS, DimensionsRegistry.REGISTERS, PortalRegistry.REGISTERS).flatMap(Collection::stream).forEach(e -> e.register(modBus));
        modBus.addListener(this::commonSetup);
        modBus.addListener(this::clientSetup);
        modBus.addListener(this::postSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        FTBStoneBlockCommands.setup();
        DimensionsMain.setup();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ToolsClient.init();
        PortalClient.init();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> DimensionsClient::init);
    }

    public void postSetup(FMLLoadCompleteEvent event) {
        ToolsMain.setup();
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        FTBStoneBlockCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

